<!doctype html>
<html lang="id">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title><?= esc($title ?? 'Halaman Tentang') ?></title>

  <!-- Bootstrap -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link rel="icon" href="<?= base_url('assets/images/logo1.png') ?>" type="image/png">

  <style>
    body{
      margin:0;
      font-family:system-ui,-apple-system,Segoe UI,Roboto,Arial;
      background:#f5f7fb;
      color:#0f172a;
    }

    /* ===== SIDEBAR (ASLI, UTUH) ===== */
    .sidebar{width:280px;min-height:100vh;overflow-y:auto}
    .sidebar a{text-decoration:none}
    .sidebar .active{background:rgba(13,110,253,.12);border-radius:.5rem}
    .sub-menu{padding-left:1rem}
    .sub-menu .list-group-item{font-size:.9rem;padding:.5rem 1rem;border:none}
    .menu-toggle{cursor:pointer;position:relative}
    .menu-toggle::after{content:'▼';position:absolute;right:1rem;font-size:.75rem}
    .menu-toggle.collapsed::after{transform:rotate(-90deg)}

    /* ===== LAYOUT ===== */
    .wrap{max-width:1100px;margin:28px auto;padding:0 18px}
    h1{font-size:32px;font-weight:800;margin:0}
    .sub{color:#64748b;font-size:14px;margin-top:6px}

    .topbar{
      display:flex;
      justify-content:space-between;
      align-items:center;
      margin-bottom:20px;
      gap:12px;
    }

    .btn{
      padding:10px 16px;
      border-radius:999px;
      font-weight:700;
      font-size:13px;
      text-decoration:none;
      display:inline-block;
      white-space:nowrap;
    }
    .btn-primary{
      background:#2563eb;
      color:#fff;
      box-shadow:0 8px 18px rgba(37,99,235,.25);
    }
    .btn-edit{background:#dbeafe;color:#1d4ed8}
    .btn-del{background:#fee2e2;color:#b91c1c;border:none}

    .alert{
      background:#ecfdf5;
      border:1px solid #bbf7d0;
      color:#065f46;
      padding:12px 14px;
      border-radius:14px;
      margin-bottom:16px;
      font-size:14px;
    }

    .card{
      background:#fff;
      border:1px solid #e5e7eb;
      border-radius:18px;
      box-shadow:0 10px 25px rgba(0,0,0,.06);
      overflow:hidden;
    }
  
    table{width:100%;border-collapse:collapse}
    th,td{padding:14px 16px;border-bottom:1px solid #e5e7eb;font-size:14px;vertical-align:top}
    th{background:#f8fafc;font-weight:800;font-size:13px}
/* ===== FIX TEKS PANJANG AGAR TIDAK MELEBAR KE SAMPING ===== */
table td {
  word-wrap: break-word;
  word-break: break-word;
  white-space: normal;
  
}

table th {
  white-space: nowrap;
}

/* khusus kolom deskripsi (lebih aman) */
td:nth-child(4) {
  word-break: break-word;
  white-space: normal;
}
    .thumb{
      width:70px;height:50px;border-radius:10px;
      object-fit:cover;border:1px solid #e5e7eb;background:#f1f5f9;
    }

    .aksi{display:flex;gap:8px;flex-wrap:wrap}
    .empty{text-align:center;padding:30px;color:#64748b}
/* ===== TAMBAHAN RESPONSIVE (AMAN) ===== */
.hamburger {
      display: none;
      font-size: 1.6rem;
      color: #fff;
      cursor: pointer;
    }

    .sidebar-overlay {
      display: none;
      position: fixed;
      inset: 0;
      background: rgba(0,0,0,.45);
      z-index: 1040;
    }

    @media (max-width: 991px) {
      .hamburger {
        display: block;
      }

      .sidebar {
        position: fixed;
        top: 0;
        left: 0;
        z-index: 1050;
        background: #fff;
        transform: translateX(-100%);
        transition: transform .3s ease;
      }

      .sidebar.show {
        transform: translateX(0);
      }

      .sidebar-overlay.show {
        display: block;
      }
    }
    
  </style>
</head>

<body>


<body class="bg-light">

<nav class="navbar navbar-expand-lg bg-primary navbar-dark">
  <div class="container-fluid">
    <a class="navbar-brand fw-bold" href="<?= site_url('admin') ?>">Welcome back Admin</a>

    <!-- TAMBAHAN: HAMBURGER (TIDAK MENGHAPUS APA PUN) -->
    <span class="hamburger ms-auto me-3" onclick="toggleSidebar()">☰</span>

    <div class="d-flex gap-2 align-items-center">
      <span class="text-white small">Halo, <?= esc(auth()->user()->username ?? 'Admin') ?></span>
      <a class="btn btn-outline-light btn-sm" href="<?= site_url('logout') ?>">Logout</a>
    </div>
  </div>
</nav>

<!-- TAMBAHAN: OVERLAY -->
<div class="sidebar-overlay" onclick="toggleSidebar()"></div>

<div class="d-flex">

  <!-- ===== SIDEBAR ASLI KAMU (UTUH, TIDAK DIHAPUS) ===== -->
  <aside class="sidebar bg-white border-end p-3" id="sidebar">
    <div class="fw-bold mb-2">Admin Panel</div>

    <?php
      $uri = service('uri')->getPath();

      $isInfoSekolahActive = ($uri === 'admin' || $uri === 'admin/' ||
                              str_starts_with($uri, 'admin/branding') ||
                              str_starts_with($uri, 'admin/visi-misi') ||
                              str_starts_with($uri, 'admin/kepsek') ||
                              str_starts_with($uri, 'admin/video-profile') ||
                              str_starts_with($uri, 'admin/data-sekolah') ||
                              str_starts_with($uri, 'admin/footer'));

      $isBeritaActive = (str_starts_with($uri, 'admin/berita') ||
                        str_starts_with($uri, 'admin/pengumuman') ||
                        str_starts_with($uri, 'admin/kelulusan') ||
                        str_starts_with($uri, 'admin/kegiatan') ||
                        str_starts_with($uri, 'admin/prestasi'));

      $isGaleriActive = (str_starts_with($uri, 'admin/galeri') ||
                        str_starts_with($uri, 'admin/guru-staf') ||
                        str_starts_with($uri, 'admin/siswa') ||
                        str_starts_with($uri, 'admin/video') ||
                        str_starts_with($uri, 'admin/ekstrakulikuler'));
    ?>

    <div class="list-group list-group-flush">
      <!-- Informasi Sekolah -->
      <a class="list-group-item list-group-item-action menu-toggle <?= $isInfoSekolahActive ? '' : 'collapsed' ?> <?= ($uri === 'admin' || $uri === 'admin/') ? 'active' : '' ?>"
         data-bs-toggle="collapse"
         href="#infoSekolahMenu"
         role="button"
         aria-expanded="<?= $isInfoSekolahActive ? 'true' : 'false' ?>"
         aria-controls="infoSekolahMenu">
        Informasi Sekolah
      </a>

      <div class="collapse <?= $isInfoSekolahActive ? 'show' : '' ?>" id="infoSekolahMenu">
        <div class="sub-menu">
          <a class="list-group-item list-group-item-action <?= ($uri === 'admin' || $uri === 'admin/') ? 'active' : '' ?>"
             href="<?= site_url('admin') ?>">Dashboard</a>

          <a class="list-group-item list-group-item-action <?= str_starts_with($uri, 'admin/visi-misi') ? 'active' : '' ?>"
             href="<?= site_url('admin/visi-misi') ?>">Visi & Misi</a>

          <a class="list-group-item list-group-item-action <?= str_starts_with($uri, 'admin/kepsek') ? 'active' : '' ?>"
             href="<?= site_url('admin/kepsek') ?>">Kata Sambutan</a>

          <a class="list-group-item list-group-item-action <?= str_starts_with($uri, 'admin/video-profile') ? 'active' : '' ?>"
             href="<?= site_url('admin/video-profile') ?>">Video Profile</a>

          <a class="list-group-item list-group-item-action <?= str_starts_with($uri, 'admin/data-sekolah') ? 'active' : '' ?>"
             href="<?= site_url('admin/data-sekolah') ?>">Statistika</a>

             <a class="list-group-item list-group-item-action <?= str_starts_with($uri, 'admin/footer') ? 'active' : '' ?>"
             href="<?= site_url('admin/footer') ?>">Footer</a>
        </div>
      </div>

      <!-- Berita -->
      <a class="list-group-item list-group-item-action menu-toggle <?= $isBeritaActive ? '' : 'collapsed' ?>"
         data-bs-toggle="collapse"
         href="#beritaMenu"
         role="button"
         aria-expanded="<?= $isBeritaActive ? 'true' : 'false' ?>"
         aria-controls="beritaMenu">
        Berita
      </a>

      <div class="collapse <?= $isBeritaActive ? 'show' : '' ?>" id="beritaMenu">
        <div class="sub-menu">
          <a class="list-group-item list-group-item-action <?= str_starts_with($uri, 'admin/pengumuman') ? 'active' : '' ?>"
             href="<?= site_url('admin/pengumuman') ?>">Pengumuman</a>

          <a class="list-group-item list-group-item-action <?= str_starts_with($uri, 'admin/kelulusan') ? 'active' : '' ?>"
             href="<?= site_url('admin/kelulusan') ?>">Pengumuman Kelulusan</a>

          <a class="list-group-item list-group-item-action <?= str_starts_with($uri, 'admin/kegiatan') ? 'active' : '' ?>"
             href="<?= site_url('admin/kegiatan') ?>">Kegiatan</a>

          <a class="list-group-item list-group-item-action <?= str_starts_with($uri, 'admin/prestasi') ? 'active' : '' ?>"
             href="<?= site_url('admin/prestasi') ?>">Prestasi</a>
        </div>
      </div>

      <!-- Galeri -->
      <a class="list-group-item list-group-item-action menu-toggle <?= $isGaleriActive ? '' : 'collapsed' ?>"
         data-bs-toggle="collapse"
         href="#galeriMenu"
         role="button"
         aria-expanded="<?= $isGaleriActive ? 'true' : 'false' ?>"
         aria-controls="galeriMenu">
        Galeri
      </a>

      <div class="collapse <?= $isGaleriActive ? 'show' : '' ?>" id="galeriMenu">
        <div class="sub-menu">
          <a class="list-group-item list-group-item-action <?= str_starts_with($uri, 'admin/guru-staf') ? 'active' : '' ?>"
             href="<?= site_url('admin/guru-staf') ?>">Guru dan Staf</a>

          <a class="list-group-item list-group-item-action <?= str_starts_with($uri, 'admin/siswa') ? 'active' : '' ?>"
             href="<?= site_url('admin/siswa') ?>">Siswa/Siswi</a>

          <a class="list-group-item list-group-item-action <?= str_starts_with($uri, 'admin/video') ? 'active' : '' ?>"
             href="<?= site_url('admin/video') ?>">Video</a>

          <a class="list-group-item list-group-item-action <?= str_starts_with($uri, 'admin/ekstrakurikuler') ? 'active' : '' ?>"
             href="<?= site_url('admin/ekstrakurikuler') ?>">Ekstrakulikuler</a>
        </div>
      </div>

      <a class="list-group-item list-group-item-action <?= str_starts_with($uri, 'admin/tentang') ? 'active' : '' ?>"
         href="<?= site_url('admin/tentang') ?>">Tentang</a>

      <a class="list-group-item list-group-item-action <?= str_starts_with($uri, 'admin/password') ? 'active' : '' ?>"
         href="<?= site_url('admin/password') ?>">Ubah Password</a>
    </div>
  </aside>
  <!-- MAIN CONTENT -->
  <main class="flex-grow-1 p-4">
    <div class="wrap">

      <div class="topbar">
        <div>
          <h1>Halaman Tentang</h1>
          <div class="sub">Kelola konten singkat untuk halaman Tentang.</div>
        </div>
        <a href="<?= base_url('admin/tentang/create') ?>" class="btn btn-primary">+ Tambah Konten</a>
      </div>

      <?php if (!empty($msg)): ?>
        <div class="alert"><?= esc($msg) ?></div>
      <?php endif; ?>

      <div class="card">
        <table>
          <thead>
            <tr>
              <th>#</th>
              <th>Foto</th>
              <th>Judul</th>
              <th>Deskripsi</th>
              <th>Aksi</th>
            </tr>
          </thead>
          <tbody>

          <?php if (empty($items)): ?>
            <tr><td colspan="5" class="empty">Belum ada konten.</td></tr>
          <?php else: ?>
            <?php foreach ($items as $i => $it): ?>
              <tr>
                <td><?= $i+1 ?></td>
                <td>
                  <?php if (!empty($it['foto'])): ?>
                    <img src="<?= base_url('uploads/tentang/'.$it['foto']) ?>" class="thumb">
                  <?php else: ?>
                    <div class="thumb"></div>
                  <?php endif; ?>
                </td>
                <td><strong><?= esc($it['judul']) ?></strong></td>
                <td><?= esc(substr(strip_tags($it['deskripsi']),0,120)) ?>…</td>
                <td>
                  <div class="aksi">
                    <a href="<?= base_url('admin/tentang/edit/'.$it['id']) ?>" class="btn btn-edit">Edit</a>

                    <!-- ✅ HAPUS AMAN -->
                    <form action="<?= base_url('admin/tentang/delete/'.$it['id']) ?>"
                          method="post"
                          onsubmit="return confirm('Yakin hapus data ini?')"
                          style="display:inline">
                      <?= csrf_field() ?>
                      <button type="submit" class="btn btn-del">Hapus</button>
                    </form>
                  </div>
                </td>
              </tr>
            <?php endforeach; ?>
          <?php endif; ?>

          </tbody>
        </table>
      </div>

    </div>
  </main>
</div>

<!-- ===== TAMBAHAN JS (AMAN) ===== -->
<script>
function toggleSidebar(){
  document.getElementById('sidebar').classList.toggle('show');
  document.querySelector('.sidebar-overlay').classList.toggle('show');
}
</script>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
